/*------------------------------------------------------------------------------*
 * File Name: ImpWizDataColumns.c												*
 * Creation: 																	*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 2005-03-04 v8.0200 QA70-7433 IMPORT_CSV_FILES							*
 * EJP 2005-06-23 v8.0256 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS			*
 * EJP 2005-09-23 v8.0309 QA70-7473 ASC_IMP_MULT_DELIM							*
 * Hong 01/17/07 ADD_SPARKLINE_TO_IMPORT_WIZARD									*
 * Hong 03/26/07 v8.0589b ADD_FORCE_ROW_SAME_SIZE								*
 *	Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT				*
 * AW 04/11/07 QA80-9609 v8.0598 MORE_ON_CHANGE_COL_IN_IMPWIZ					*
 * Sim 06-05-2007 LOAD_FILTER_DESIGN_TO_DLG										*
 *	Hong QA80-9972 REMOVE_ORIGIN_SETTING_FOR_NUMERIC_SEPARATOR					*
 * AW 07/12/07 QA80-10040 NUMERIC_SEPERATOR_ERROR								*
 *	Hong 07/13/07 QA80-10040 TEMP_GET_BACK_ITEM_FOCUS_AS_UPDATEPREVIEW_EAT_THE_FOCUS	
 *	Sim 08-06-2007 SUPPORT_SMART_SPARKLINE										*
 *	Hong 09/04/07 QA80-9910 v8.0695 FIX_DELIMITER_OTHER_FAIL_INITIAL_BY_FILTER	*
 *	Hong 09/18/07 QA80-10387 FIX_DESIGNATION_INCONSISTENCE_BETWEEN_PRIVIEW_AND_IMPORT
 *	Hong 09/19/07 QA80-9206 FIX_ZERO_COL_NUM_FAIL_CORRECT_IMPORT_MULTI_FILES	*
 *	Hong 09/21/07 QA80-10397 COL_DESIGN_BE_EDITABLE_NO_NEED_INITIAL_BY_FILTER	*
 *	Folger 11/08/07 CLEAN_CODE_TO_LOCALIZE										*
 *	Hong 11/30/07 QA80-10541 FIX_SEMICOLON_SEPARATOR_FAIL_WORK_AS_MIXED_UP_USER_SEPARATOR
 *	Kyle 01/04/2009 QA70-12890-P4 CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT
 *	Hong 03/27/09 QA80-13360 ADD_HINT_ITEM_FOR_DATA_FMT_COMBO					*
 *	Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
 *------------------------------------------------------------------------------*/
#include <Origin.h>
#include "IWfirst.h"

//------ Folger 11/08/07 CLEAN_CODE_TO_LOCALIZE
//#define STR_DESIGN_UNCHANGED "<Unchanged>" ///---Sim 06-05-2007 LOAD_FILTER_DESIGN_TO_DLG
#define STR_DESIGN_UNCHANGED _LE("<Unchanged>")
//------ End CLEAN_CODE_TO_LOCALIZE
//#define STR_DESIGN_USER_DEF "<UserDefined>" ///---Sim 06-05-2007 LOAD_FILTER_DESIGN_TO_DLG
#define STR_DESIGN_DEFAULT "XYY" ///---Sim 06-05-2007 LOAD_FILTER_DESIGN_TO_DLG

/// Hong 03/27/09 QA80-13360 ADD_HINT_ITEM_FOR_DATA_FMT_COMBO
#define	STR_HINT_ITEM	_L("<Hint...>")
/// end ADD_HINT_ITEM_FOR_DATA_FMT_COMBO

ASCColumnsPreviewList::ASCColumnsPreviewList() 
{
}
///Danice 2/16/04 v8.0821 ADD_SOME_ACCESS_FUNCTION
void ASCColumnsPreviewList::Init(int nID, int iRenameCols, WndContainer& dlg)
{		
	GridListControl::Init(nID, dlg);

	//m_flx.AllowUserResizing = flexResizeColumns;
	//SetupRowsCols(0, (iRenameCols > 0 ? 2 : 1));	///Danice 3/29/04 v8.0844b CHANGE_PARA_ORDER_ROW_COL
	SetupRowsCols((iRenameCols > 0 ? 2 : 1), 0);
	//m_flx.FixedCols = 0;
	//m_flx.FixedRows = (iRenameCols > 0 ? 2 : 1);
	m_flx.Editable = flexEDNone;
	m_flx.MergeCells = flexMergeSpill;
	m_flx.OwnerDraw = flexODOver;
	//m_flx.Rows = m_flx.FixedRows;
	///Danice 2/20/04 v8.0822 INIT_GRID
	m_flx.SelectionMode = flexSelectionFree ;
	m_flx.AllowSelection = true;
	m_flx.ExtendLastCol = false;
	///END INIT_GRID
}

void ASCColumnsPreviewList::ReadFileIntoFixedWidthGrid(string strFileName, int iTotalHeaderLines, int iRenameCols)
{
	m_flx.Col = 0; // read into first column

	StringArray saLines;

	int nFixedRows = m_flx.FixedRows;
	if( nFixedRows > 1 ) // if show column names
	{
		///ReadFileLines(saLines, s_strDataFile, 1, s_ascimp.iHeaderLines - s_ascimp.iRenameCols);
		ReadFileLines(saLines, strFileName, 1, iTotalHeaderLines - iRenameCols);
		m_flx.Row = 1;
		m_flx.Text = saLines[0];
		saLines.SetSize(0);
	}

	ReadFileLines(saLines, strFileName, 50, iTotalHeaderLines);
	m_flx.Rows = nFixedRows + saLines.GetSize();

	for( int n = 0; n < saLines.GetSize(); n++ )
	{
		m_flx.Row = nFixedRows + n;
		m_flx.Text = saLines[n];
	}
}

void ASCColumnsPreviewList::SetGridColWidthInChars(int nCol, int nChars, int FixedWidthGridFont)
{
	if( nCol >= m_flx.Cols )
		return;
	//int iTwips = PixelsToTwips(ctrlGrid, s_iFixedWidthGridFontWidth * nChars);
	int iTwips = PixelsToTwips(FixedWidthGridFont * nChars);
	SetColWidth(nCol, iTwips);
}
///END ADD_SOME_ACCESS_FUNCTION


// TD 1-14-03
ImpWizDataColumnsPage::ImpWizDataColumnsPage()
{
	m_bInit = FALSE;
}
// end 1-14-03

///Danice 12/25/03 v7.5788 NOTUSE_SHOW
DWORD ImpWizDataColumnsPage::OnShowStatus(DWORD InternalStatus)
{
	return (IS_FILTER_TYPE_ASCII ? PSS_Show : PSS_Ignore);
}
///END NOTUSE_SHOW

BOOL ImpWizDataColumnsPage::OnInit_AscColumns()	//Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	ON_PAGE_CHECK_ASC_COLUMNS
	
	///Danice PAGE_INIT_ONCE
	if(!ImpWizardPage::Init())
		return FALSE;
	///END PAGE_INIT_ONCE
	
	///Jason 12/18/03 v7.5781 MOVED_INITIAL_FUNCTION	
	m_btnAddCol = 			GetItem(IDC_ADD_COL);
	m_btnDelCol = 			GetItem(IDC_DEL_COL);
	m_btnLeadingZeroes = 	GetItem(IDC_IW_LEADING_ZERO);
	m_btnRefresh = 			GetItem(IDC_COLS_REFRESH);
	m_cbDateFormat = 		GetItem(IDC_CUSTOM_DATE_FORMAT);
	///Kyle 01/04/2009 QA70-12890-P4 CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT
	vector<string> vsCustomDateFormat;
	get_custom_date_format_list(vsCustomDateFormat);
	/// Hong 03/27/09 QA80-13360 ADD_HINT_ITEM_FOR_DATA_FMT_COMBO
	//vsCustomDateFormat.InsertAt(0, SZ_IW_NONE);
	vsCustomDateFormat.Sort(); // Hong, I turn off Sort property of this control in resource as i want to skip sorting <Hint...>, so need add back here
	vsCustomDateFormat.InsertAt(0, SZ_IW_NONE);
	vsCustomDateFormat.Add(STR_HINT_ITEM);
	/// end ADD_HINT_ITEM_FOR_DATA_FMT_COMBO
	SetComboBoxItems(m_cbDateFormat, vsCustomDateFormat);
	///End CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT
	
	m_chkFixedWidthGrid = 	GetItem(IDC_COL_PREV_SWITCH);

	/// EJP 2005-09-23 v8.0309 QA70-7473 ASC_IMP_MULT_DELIM
	///m_cmbDelimiter = 		GetItem(IDC_COLS_DELIMITER);
	/// end QA70-7473 ASC_IMP_MULT_DELIM

	m_cmbDesig = 			GetItem(IDC_IW_COL_PLOT_DESIG);
	//m_ctrlGrid = 			GetItem(IDC_COL_WIDTH_PREVIEW_GRID);	///Danicee CHANGE_GRID_TO_CLASS
	m_ebDelimiter = 		GetItem(IDC_COLS_CHAR);
	//m_ebFixedWidths = 		GetItem(IDC_COLS_WIDTHS);
	m_ebNumCols = 			GetItem(IDC_NUMBER_OF_COLS);
	//m_ebxDelimiter = 		GetItem(IDC_COLS_CHAR);
	//m_ebxFixedWidths = 		GetItem(IDC_COLS_WIDTHS);
	m_editFixedWidths = 	GetItem(IDC_COLS_WIDTHS);
	m_rbDelimited = 		GetItem(IDC_COLS_DELIMITED);	///Danice 1/9/04 V8.0797 USE_AS_DATA_MEMBER
	//m_wc = 					GetItem(IDC_COL_WKS_PREVIEW);

	m_btnRemoveQuotes = GetItem(IDC_REMOVE_QUOTES); /// EJP 2005-03-04 v8.0200 QA70-7433 IMPORT_CSV_FILES

	/// EJP 2005-06-23 v8.0256 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS
	m_cbNumSeparator = GetItem(IDC_NUM_SEPARATOR);
	/// Hong QA80-9972 REMOVE_ORIGIN_SETTING_FOR_NUMERIC_SEPARATOR
	//int nNumSepIDs[] = {NF_IS_ORIGIN, NF_IS_AMERICAN, NF_IS_EUROPEAN, NF_IS_FRENCH, NF_IS_SWISS};
	//m_pSheet->iw_InitComboBox(m_cbNumSeparator, _L("Origin's Setting|1,000.00|1.000,00|1 000,00|1'000.00"), nNumSepIDs);
	int nNumSepIDs[] = {NF_IS_AMERICAN, NF_IS_EUROPEAN, NF_IS_FRENCH, NF_IS_SWISS};
	m_pSheet->iw_InitComboBox(m_cbNumSeparator, "1,000.00|1.000,00|1 000,00|1'000.00", nNumSepIDs);
	/// end REMOVE_ORIGIN_SETTING_FOR_NUMERIC_SEPARATOR
	/// end ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS

	/// EJP 2005-09-23 v8.0309 QA70-7473 ASC_IMP_MULT_DELIM
	m_chkColDelimTab = GetItem(IDC_COL_DELIM_TAB);
	m_chkColDelimComma = GetItem(IDC_COL_DELIM_COMMA);
	m_chkColDelimSpace = GetItem(IDC_COL_DELIM_SPACE);
	m_chkColDelimSemiColon = GetItem(IDC_COL_DELIM_SEMICOLON);
	m_chkColDelimOther = GetItem(IDC_COL_DELIM_OTHER);
	m_chkCombineConsecDelim = GetItem(IDC_DELIM_COMBINE_CONSEC);
	m_cbTextQualifier = GetItem(IDC_TEXT_QUALIFIER);
	m_cbTextQualifier.AddString(SZ_IW_NONE);
	m_cbTextQualifier.AddString("\"");
	m_cbTextQualifier.AddString("\'");
	/// end ASC_IMP_MULT_DELIM
	///---Sim 08-06-2007 SUPPORT_SMART_SPARKLINE
	//m_chkAddSparklines = GetItem(IDC_IW_ADD_SPARKLINES); // Hong 01/17/07 ADD_SPARKLINE_TO_IMPORT_WIZARD
	m_cbSparklines = GetItem(IDC_IW_ADD_SPARKLINES);
	///---END SUPPORT_SMART_SPARKLINE
	
	m_chkForceSameSize = GetItem(IDC_IW_FILL_NANUM_FORCE_SAME_SIZE); // Hong 03/26/07 v8.0589b ADD_FORCE_ROW_SAME_SIZE
	
	m_chkKeepColFormat = GetItem(IDC_IW_KEEP_COL_FORMAT); // Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT
	
	if( !m_wc ) /// EJP 02-26-2004 v7.5828 ONLY_CREATE_WKS_CTRL_ONCE
	{
		Control ctrlTmp =		GetItem(IDC_COL_WKS_PREVIEW);
		HWND hWnd = ctrlTmp.GetSafeHwnd();
		if(hWnd)
			m_wc.CreateControl(hWnd);
		else
			ASSERT(FALSE);
	}
	
	///End MOVED_INITIAL_FUNCTION
	
	///Danice READ_FROM_SHEET
	m_pAscimp = m_pSheet->GetASCIMP_Pointer();		///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	//m_pSheet->GetASCIMP(m_pAscimp);
	//m_pSheet->GetColWidths(m_vColWidths);		///Danice 1/16/04 v8.0800 USE_ONLY_IN_DATA_COLUMNS
	///END READ_FROM_SHEET

	_MSG_INT(OnInit_AscColumns, m_pAscimp->iDelimited)

	
	convertCommaSeparatedStringsToShorts(m_vColWidths, m_pAscimp->szFixedWidth);

	///Danice 2/12/04 v8.0819 CHANGE_GRID_TO_CLASS
	/*
	////////////////////////////////
	//Control ctrlGrid = ImportWizDlg.GetItem(IDC_COL_WIDTH_PREVIEW_GRID, IDD_AIW_COLUMNS);	///Jason 12/18/03 v7.5781 NO_NEED_DIALOG_CALL	
	if( m_ctrlGrid )
	{
		Object objGrid = m_ctrlGrid.GetActiveXControl();
		if( objGrid )
		{
			objGrid.AllowUserResizing = flexResizeColumns;
			objGrid.FixedCols = 0;
			objGrid.FixedRows = (m_pAscimp->iRenameCols > 0 ? 2 : 1);
			objGrid.Editable = flexEDNone;
			objGrid.MergeCells = flexMergeSpill;
			objGrid.OwnerDraw = flexODOver;
			objGrid.Rows = objGrid.FixedRows;
		}
	}
	*/
	m_ctrlPreviewList.Init(IDC_COL_WIDTH_PREVIEW_GRID, m_pAscimp->iRenameCols, *this);
	///END CHANGE_GRID_TO_CLASS
		
	_MSG_INT(OnInit_AscColumns, m_pAscimp->iDelimited)
	///Danice 12/23/03 v7.5786 SAVE_CHANGE		///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	//m_pSheet->SetColWidths(m_vColWidths);
	//m_pSheet->SetASCIMP(m_pAscimp);
	///END SAVE_CHANGE

	/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	m_bDisableUpdatePreview = false;
	/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT

	////////////////////////////////
	return TRUE;
}

BOOL ImpWizDataColumnsPage::OnActive_AscColumns()	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	ON_PAGE_CHECK_ASC_COLUMNS
	
	fuGetASCIMP(IW_FILTER, *m_pAscimp); ///---Sim 09-14-2006 UPDATE_ASCII_STUCTURE_FROM_FILTER
	
	//m_pSheet->GetASCIMP(m_pAscimp);		///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	//m_pSheet->GetColWidths(m_vColWidths);		///Danice 1/16/04 v8.0800 USE_ONLY_IN_DATA_COLUMNS

	_MSG_INT(OnActive_AscColumns, m_pAscimp->iDelimited)

	/// EJP 10-20-2003 v7.5726 QA70-5374 ALLOW_CHANGING_PREVIEW_FONT
	//WorksheetControl wc = ImportWizDlg.GetItem(IDC_COL_WKS_PREVIEW, IDD_AIW_COLUMNS);		///Jason 12/18/03 v7.5781 MOVE_TO_ON_INIT_DATA_COLUMNS
	m_wc.SetFont(IW_PREVIEW_FONT);
	/// end ALLOW_CHANGING_PREVIEW_FONT
	
	/// EJP 07-14-2003 v7.0624 SCAN_FOR_NUM_COLS_ON_CHANGE_HEADER_LINES
	/// Hong 09/19/07 QA80-9206 FIX_ZERO_COL_NUM_FAIL_CORRECT_IMPORT_MULTI_FILES
	/* this code is not reasonable as user may have specify column number or keep default to 0 meaning auto detect by file	
	if( IS_RESCAN_FOR_NUM_COLS )
	{
		//m_pAscimp->iNumColumns = iwScanForNumColumns(s_strDataFile, m_pAscimp);	///Danice 1/16/04 v8.0800 FIT_FUNCTION_ARGUMENT
		m_pAscimp->iNumColumns = iwScanForNumColumns(s_strDataFile, *m_pAscimp);
		DISABLE_RESCAN_FOR_NUM_COLS;
	}
	*/
	/// end FIX_ZERO_COL_NUM_FAIL_CORRECT_IMPORT_MULTI_FILES
	/// end SCAN_FOR_NUM_COLS_ON_CHANGE_HEADER_LINES

	/// EJP 10-23-2003 v7.5726 QA70-5374 ALLOW_CHANGING_PREVIEW_FONT
	//iw_SetGridFont(IDC_COL_WIDTH_PREVIEW_GRID, IW_PREVIEW_FONT);	///Danice 12/26/03 v7.5789 PUT_FUNCTION_TO_SHEET
	//m_pSheet->iw_SetGridFont(m_ctrlGrid, IW_PREVIEW_FONT);		///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	m_ctrlPreviewList.SetGridFont(IW_PREVIEW_FONT);	///Danice CHANGE_GRID_TO_CLASS
	//Control ctrlGrid = ImportWizDlg.GetItem(IDC_COL_WIDTH_PREVIEW_GRID, IDD_AIW_COLUMNS);	///Jason 12/18/03 v7.5781 MOVE_TO_ON_INIT_DATA_COLUMNS
	//if( m_ctrlGrid )		///Danicee CHANGE_GRID_TO_CLASS
	convertCommaSeparatedStringsToShorts(m_vColWidths, m_pAscimp->szFixedWidth); ///---Sim 09-14-2006 GET_CORRECT_FIXED_WIDTH
	AscColumns_SetGridColWidthInChars(m_vColWidths);
	/// end ALLOW_CHANGING_PREVIEW_FONT

	AscColumns_UpdateData(FALSE);
	AscColumns_EnableDelimiterCtrls();
	/// AW 04/11/07 QA80-9609 v8.0598 MORE_ON_CHANGE_COL_IN_IMPWIZ
	// import data file twice here, it was called inside AscColumns_UpdateData(FALSE)
	//UpdatePreview(IDD_AIW_COLUMNS);           
	/// END MORE_ON_CHANGE_COL_IN_IMPWIZ
	_MSG_INT(OnActive_AscColumns_After_UpdatePreview, m_pAscimp->iDelimited)
	// TD 1-14-03
	m_bInit = TRUE;
	// end 1-14-03
	/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	Control		ctrl;
	uint		nIDs[] = {IDC_APPLY_NUM_COLS, IDC_IW_COL_SET_PLOT_DESIG, IDC_APPLY_DATE_FORMAT, IDC_COLS_REFRESH};
	for ( int ii = 0; ii < sizeof(nIDs) / sizeof(nIDs[0]); ii++)
	{
		ctrl = GetItem(nIDs[ii]);
		if ( ctrl )
			ctrl.Enable = false;
	}
	/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT	
	return TRUE;
}

bool ImpWizDataColumnsPage::OnKillActive_AscColumns()
{
	_MSG_INT(OnKillActive_AscColumns, m_pAscimp->iDelimited)
	///Danice SAVE_CHANGE		///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	//m_pSheet->SetColWidths(m_vColWidths);		///Danice 1/16/04 v8.0800 USE_ONLY_IN_DATA_COLUMNS
	//m_pSheet->SetASCIMP(m_pAscimp);
	///END SAVE_CHANGE	
	/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	BOOL		bNeedUpdatePreview = false, bOldVal = m_bDisableUpdatePreview;
	m_bDisableUpdatePreview = true;
	
	Control		ctrl;

	ctrl = GetItem(IDC_COLS_REFRESH);
	if ( ctrl && ctrl.Enable )
	{
		OnClickRefresh_AscColumns(ctrl);
		bNeedUpdatePreview = true;
	}
	
	ctrl = GetItem(IDC_APPLY_NUM_COLS);
	if ( ctrl && ctrl.Enable )
	{
		OnClickApplyNumCols_AscCols(ctrl);
		bNeedUpdatePreview = true;
	}
	ctrl = GetItem(IDC_IW_COL_SET_PLOT_DESIG);
	if ( ctrl && ctrl.Enable )
	{
		OnClickSetDesignations_AscColumns(ctrl);
		bNeedUpdatePreview = true;
	}
	ctrl = GetItem(IDC_APPLY_DATE_FORMAT);
	if ( ctrl && ctrl.Enable )
	{
		AscCols_ApplyDateFormat(ctrl);
		bNeedUpdatePreview = true;
	}	

	m_bDisableUpdatePreview = bOldVal;
	if ( bNeedUpdatePreview )
		UpdatePreview(IDD_AIW_COLUMNS);
	/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT	
	fuSetASCIMP(IW_FILTER, *m_pAscimp); ///---Sim 09-14-2006 UPDATE_ASCII_STUCTURE_TO_FILTER
	return true;
}

BOOL ImpWizDataColumnsPage::OnClickLeadingZeroes_AscColumns(Control ctrl)	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	Button btnLeadingZeroes(ctrl);
	m_pAscimp->iLeadingZeroes = btnLeadingZeroes.Check;
	UpdatePreview(IDD_AIW_COLUMNS);
	return TRUE;
}

BOOL ImpWizDataColumnsPage::OnClickDelimited_AscColumns(Control ctrl)	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	// TD 1-14-03
	if(!m_bInit)
		return TRUE;
	// end 1-14-03
	Button radioDelimited(ctrl);
	if( radioDelimited.Check )
	{
		m_pAscimp->iDelimited = 1; // Delimiter separated columns
		//m_pAscimp->iNumColumns = s_iNumColsEstimated;
		m_pAscimp->iNumColumns = m_pSheet->GetNumColsEstimated();	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	}
	else
	{
		m_pAscimp->iDelimited = 0; // Fixed width columns
		m_pAscimp->iNumColumns = m_vColWidths.GetSize();
	}
	AscColumns_EnableDelimiterCtrls();
	UpdatePreview(IDD_AIW_COLUMNS);
	return TRUE;
}

BOOL ImpWizDataColumnsPage::OnSelChangeDelimiter_AscColumns(Control ctrl)	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	ComboBox comboDelimiter(ctrl);
	m_pAscimp->iDelimiter = comboDelimiter.GetCurSel();
	AscColumns_EnableDelimiterCtrls();
	UpdatePreview(IDD_AIW_COLUMNS);
	return TRUE;
}

/// EJP 2005-06-23 v8.0256 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS
BOOL ImpWizDataColumnsPage::OnSelChangeNumSep(Control ctrl)
{
	int i = m_cbNumSeparator.GetCurSel();
	m_pAscimp->nNumSep = m_cbNumSeparator.GetItemData(i);
	UpdatePreview(IDD_AIW_COLUMNS);
	/// AW 07/12/07 QA80-10040 NUMERIC_SEPERATOR_ERROR
	// In UpdatePreview the focus was changed, need get it back.
	SetFocus(GetSafeHwnd());
	SetFocus(ctrl.GetSafeHwnd());/// Hong 07/13/07 QA80-10040 TEMP_GET_BACK_ITEM_FOCUS_AS_UPDATEPREVIEW_EAT_THE_FOCUS
	/// END NUMERIC_SEPERATOR_ERROR
	return TRUE;
}
/// end ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS

BOOL ImpWizDataColumnsPage::OnEditChangeCharacter_AscColumns(Control ctrl)	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	/// EJP 2005-09-30 v8.0312 QA70-7473 ASC_IMP_MULT_DELIM
	///	Edit ebxDelimiter(ctrl);
	///	string str = ebxDelimiter.Text;
	///	m_pAscimp->cChar = str[0];
	UpdateASCIMPDelimitersFromDialog();
	/// end ASC_IMP_MULT_DELIM
	UpdatePreview(IDD_AIW_COLUMNS);
	return TRUE;
}

BOOL ImpWizDataColumnsPage::OnEditChangeColumnWidths_AscColumns(Control ctrl)	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	///Danice 12/29/03 v7.5790 ADD_BUSY_IN_SHEET
	//BOOL s_bBusy = FALSE;
	m_pSheet->SetBusy(false);	
	//if( s_bBusy )
	if(m_pSheet->IsBusy())
		return FALSE;
	//s_bBusy = TRUE;
	m_pSheet->SetBusy(true);
	
	Edit ebxFixedWidths(ctrl);
	string strWidths = ebxFixedWidths.Text;
	string str = strWidths.SpanIncluding("0123456789,");
	if( str.Compare(strWidths) ) // If strings are not same then not all legal characters
	{
		int nChar = str.GetLength();
		ebxFixedWidths.SetSel(nChar, nChar + 1);
		ebxFixedWidths.ReplaceSel(""); // Replace illegal character with ""
		MessageBeep(MB_OK);
	}
	else // all legal characters
	{
		SET_FIXED_WIDTHS_CHANGED;
		/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
		Control		ctrlApply = GetItem(IDC_COLS_REFRESH);
		if ( ctrlApply )
			ctrlApply.Enable = TRUE;
		/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	}

	//Button btnRefresh = ImportWizDlg.GetItem(IDC_COLS_REFRESH, IDD_AIW_COLUMNS);
	//btnRefresh.Enable = !ebxFixedWidths.Text.IsEmpty();
	
	//s_bBusy = FALSE;
	m_pSheet->SetBusy(false);
	///END ADD_BUSY_IN_SHEET

	return TRUE;
}

/// EJP 07-21-2003 v7.0630 QA70-4073 ADD_APPLY_BUTTON_TO_UPDATE_PREVIEW
///static BOOL AscCols_OnChangeNumCols(Control ctrl)
BOOL ImpWizDataColumnsPage::OnClickApplyNumCols_AscCols(Control ctrl)	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
/// end ADD_APPLY_BUTTON_TO_UPDATE_PREVIEW
{
	/// EJP 07-21-2003 v7.0630 QA70-4073 ADD_APPLY_BUTTON_TO_UPDATE_PREVIEW
	///Edit ebNumCols(ctrl);
	//Edit ebNumCols = ImportWizDlg.GetItem(IDC_NUMBER_OF_COLS, IDD_AIW_COLUMNS);	///Jason 12/18/03 v7.5781 MOVE_TO_ON_INIT_DATA_COLUMNS
	/// end ADD_APPLY_BUTTON_TO_UPDATE_PREVIEW
	int i = atoi(m_ebNumCols.Text);
	if( i >= 0 )
	{
		m_pAscimp->iNumColumns = i;
		UpdatePreview(IDD_AIW_COLUMNS);
	}
	/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	ctrl.Enable = false;
	/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	return TRUE;
}

/// EJP 10-13-2003 v7.5717 QA70-5318 CUSTOM_DATE_FORMAT
BOOL ImpWizDataColumnsPage::AscCols_ApplyDateFormat(Control ctrl)
{
	//ComboBox cbDateFormat = ImportWizDlg.GetItem(IDC_CUSTOM_DATE_FORMAT, IDD_AIW_COLUMNS);	///Jason 12/18/03 v7.5781 MOVE_TO_ON_INIT_DATA_COLUMNS
	if( m_cbDateFormat )
	{
		string str;
		m_cbDateFormat.GetLBText(0, str); // get text for <None>
		if( 0 == str.Compare(m_cbDateFormat.Text) )
			str.Empty();
		else
			str = m_cbDateFormat.Text;
		lstrcpyn(m_pAscimp->szDateFormat, str, MAX_SIZE_CUSTOM_FORMAT);
		/// SY 06-09-2004 v7.5886 QA70-5417.33 APPLY_CUSTOM_DATE_FORMAT
		m_pAscimp->iAutoColTypes = 0; // Disable auto column type
		/// end APPLY_CUSTOM_DATE_FORMAT
		UpdatePreview(IDD_AIW_COLUMNS);
		/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
		ctrl.Enable = false;
		/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
		return TRUE;
	}
	return FALSE;
}
/// end CUSTOM_DATE_FORMAT

void ImpWizDataColumnsPage::AscColumns_UpdateFixedWidthColStr()
{
	string str;
	convertShortsToCommaSeparatedStrings(str, m_vColWidths);
	lstrcpyn(m_pAscimp->szFixedWidth, str, MAX_FIXED_COL_WIDTH);
	//Edit editFixedWidths = ImportWizDlg.GetItem(IDC_COLS_WIDTHS, IDD_AIW_COLUMNS);	///Jason 12/18/03 v7.5781 MOVE_TO_ON_INIT_DATA_COLUMNS
	m_editFixedWidths.Text = str;
	
	///---Sim 09-14-2006 UPDATE_NUM_OF_COLUMNS
	if( 1 == m_chkFixedWidthGrid.Check ) // Fixed width columns
	{
		m_pAscimp->iNumColumns = m_vColWidths.GetSize();
		m_ebNumCols.Text.Format("%d", m_pAscimp->iNumColumns);
	}
	///---END UPDATE_NUM_OF_COLUMNS
}

BOOL ImpWizDataColumnsPage::OnClickRefresh_AscColumns(Control ctrl)	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	//Edit editFixedWidths = ImportWizDlg.GetItem(IDC_COLS_WIDTHS, IDD_AIW_COLUMNS);	///Jason 12/18/03 v7.5781 MOVE_TO_ON_INIT_DATA_COLUMNS
	lstrcpyn(m_pAscimp->szFixedWidth, m_editFixedWidths.Text, MAX_FIXED_COL_WIDTH);
	
	convertCommaSeparatedStringsToShorts(m_vColWidths, m_pAscimp->szFixedWidth);
	m_pAscimp->iNumColumns = m_vColWidths.GetSize();
	
	//Control ctrlGrid = ImportWizDlg.GetItem(IDC_COL_WIDTH_PREVIEW_GRID, IDD_AIW_COLUMNS);	///Jason 12/18/03 v7.5781 MOVE_TO_ON_INIT_DATA_COLUMNS
	AscColumns_SetGridColWidthInChars(m_vColWidths);	

	UpdatePreview(IDD_AIW_COLUMNS);
	AscColumns_UpdateData(FALSE); /// EJP 09-23-2003 v7.5702 QA70-5135.27 UPDATE_NUMCOLS_ON_APPLY_FIXEDWIDTH
	
	/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	ctrl.Enable = false;
	/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT

	return true;
}

BOOL ImpWizDataColumnsPage::OnClickSetDesignations_AscColumns(Control ctrl)	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	//ComboBox comboDesignations = ImportWizDlg.GetItem(IDC_IW_COL_PLOT_DESIG, IDD_AIW_COLUMNS);	///Jason 12/18/03 v7.5781 MOVE_TO_ON_INIT_DATA_COLUMNS
	string strDesignations = m_cmbDesig.Text;
	AscColumns_SetColumnDesignations(strDesignations);

	/// Hong 09/18/07 QA80-10387 FIX_DESIGNATION_INCONSISTENCE_BETWEEN_PRIVIEW_AND_IMPORT
	//UpdateWksCtrl(IDD_AIW_COLUMNS); // do not re-import, just update wks ctrl
	UpdatePreview(IDD_AIW_COLUMNS); // later should add DWORD ctrl to let preview code just do updat but not re-import
	/// end FIX_DESIGNATION_INCONSISTENCE_BETWEEN_PRIVIEW_AND_IMPORT
	/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	ctrl.Enable = false;
	/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT

	return true;
}

void ImpWizDataColumnsPage::AscColumns_EnableDelimiterCtrls()
{
	///Jason 12/18/03 v7.5781 MOVE_TO_ON_INIT_DATA_COLUMNS
	//Button rbDelimited = ImportWizDlg.GetItem(IDC_COLS_DELIMITED, IDD_AIW_COLUMNS);			
	//ComboBox cmbxDelimiter = ImportWizDlg.GetItem(IDC_COLS_DELIMITER, IDD_AIW_COLUMNS);		
	//Edit ebxDelimiter = ImportWizDlg.GetItem(IDC_COLS_CHAR, IDD_AIW_COLUMNS);				
	//Edit ebxFixedWidths = ImportWizDlg.GetItem(IDC_COLS_WIDTHS, IDD_AIW_COLUMNS);			
	//Button btnRefresh = ImportWizDlg.GetItem(IDC_COLS_REFRESH, IDD_AIW_COLUMNS);			
	//Button chkFixedWidthGrid = ImportWizDlg.GetItem(IDC_COL_PREV_SWITCH, IDD_AIW_COLUMNS);	
	//WorksheetControl wc = ImportWizDlg.GetItem(IDC_COL_WKS_PREVIEW, IDD_AIW_COLUMNS);		
	//Control ctrlGrid = ImportWizDlg.GetItem(IDC_COL_WIDTH_PREVIEW_GRID, IDD_AIW_COLUMNS);	
	///End MOVE_TO_ON_INIT_DATA_COLUMNS
	
	//Button m_rbDelimited = GetItem(IDC_COLS_DELIMITED);	///Danice 1/9/04 V8.0797 USE_AS_DATA_MEMBER
	///Danice CHANGE_GRID_TO_CLASS
	//if( !m_ctrlGrid )
		//return;
	///END CHANGE_GRID_TO_CLASS

	if( m_rbDelimited.Check == 1 ) // Delimiter separated columns
	{
		/// EJP 2005-09-23 v8.0309 QA70-7473 ASC_IMP_MULT_DELIM
		///m_cmbDelimiter.Enable = 1;
		///if( m_cmbDelimiter.GetCurSel() == ASCIMP_DELIM_OTHER )
		///	m_ebDelimiter.Enable = 1;
		///else
		///	m_ebDelimiter.Enable = 0;
		/// end ASC_IMP_MULT_DELIM
		m_editFixedWidths.Enable = 0;
		m_btnRefresh.Enable = 0;
		m_chkFixedWidthGrid.Enable = 0;
		//m_ctrlGrid.Visible = 0;	///Danice CHANGE_GRID_TO_CLASS
		m_ctrlPreviewList.SetVisible(0);
		m_wc.Visible = 1;
		/// Hong 02/01/07 NO_NEED_TEXT_QUALIFIER_WHEN_FIXED_WIDTH  :ask by Justin
		m_cbTextQualifier.Enable = 1;
		m_btnRemoveQuotes.Enable = m_pAscimp->cQuote;
		/// end DISABLE_TEXT_QUALIFIER_WHEN_FIXED_WIDTH
	}
	else // Fixed width columns
	{
		/// EJP 2005-09-23 v8.0309 QA70-7473 ASC_IMP_MULT_DELIM
		///m_cmbDelimiter.Enable = 0;
		///m_ebDelimiter.Enable = 0;
		/// end ASC_IMP_MULT_DELIM
		m_editFixedWidths.Enable = 1;
		m_btnRefresh.Enable = 1;
		m_chkFixedWidthGrid.Enable = 1;
		/// Hong 02/01/07 NO_NEED_TEXT_QUALIFIER_WHEN_FIXED_WIDTH
		m_cbTextQualifier.Enable = 0;
		m_btnRemoveQuotes.Enable = 0;
		/// end DISABLE_TEXT_QUALIFIER_WHEN_FIXED_WIDTH
		if( m_chkFixedWidthGrid.Check )
		{
			//m_ctrlGrid.Visible = 1;	///Danice CHANGE_GRID_TO_CLASS
			m_ctrlPreviewList.SetVisible(1);
			m_wc.Visible = 0;
		}
		else
		{
			//m_ctrlGrid.Visible = 0;	///Danice CHANGE_GRID_TO_CLASS
			m_ctrlPreviewList.SetVisible(0);
			m_wc.Visible = 1;
		}
	}
	
	/// EJP 2005-09-23 v8.0309 QA70-7473 ASC_IMP_MULT_DELIM
	m_chkColDelimTab.Enable = m_rbDelimited.Check;
	m_chkColDelimComma.Enable = m_rbDelimited.Check;
	m_chkColDelimSpace.Enable = m_rbDelimited.Check;
	m_chkColDelimSemiColon.Enable = m_rbDelimited.Check;
	m_chkColDelimOther.Enable = m_rbDelimited.Check;
	m_ebDelimiter.Enable = (m_rbDelimited.Check && m_chkColDelimOther.Check);
	m_chkCombineConsecDelim.Enable = m_rbDelimited.Check;
	/// end ASC_IMP_MULT_DELIM

	//Button btnAddCol = ImportWizDlg.GetItem(IDC_ADD_COL, IDD_AIW_COLUMNS);	///Jason 12/18/03 v7.5781 MOVE_TO_ON_INIT_DATA_COLUMNS
	m_btnAddCol.Enable = (m_chkFixedWidthGrid.Check && m_chkFixedWidthGrid.Enable);
	//Button btnDelCol = ImportWizDlg.GetItem(IDC_DEL_COL, IDD_AIW_COLUMNS);	///Jason 12/18/03 v7.5781 MOVE_TO_ON_INIT_DATA_COLUMNS
	m_btnDelCol.Enable = (m_chkFixedWidthGrid.Check && m_chkFixedWidthGrid.Enable);
}

bool ImpWizDataColumnsPage::AscColumns_SetColumnDesignations(LPCSTR lpcszDesignations)
{
	string strDesignations(lpcszDesignations);
	//------ Folger 11/08/07 CLEAN_CODE_TO_LOCALIZE
	//strDesignations.Replace(STR_DESIGN_UNCHANGED, ""); ///---Sim 06-05-2007 LOAD_FILTER_DESIGN_TO_DLG
	if (compare_string_localization(strDesignations, STR_DESIGN_UNCHANGED))
		strDesignations.Empty();
	//------ End CLEAN_CODE_TO_LOCALIZE
	BOOL bRepeat = FALSE;
	int i = strDesignations.Find(' ');
	if( i != -1 )
	{
		bRepeat = TRUE;
		strDesignations.Delete(0, i + 1);
	}
	strDesignations.Replace("YErr", "E");

	fuSetDesignations(s_trFilter, strDesignations);
	fuSetRepetitive(s_trFilter, bRepeat);
	
	///---Sim 06-05-2007 LOAD_FILTER_DESIGN_TO_DLG
	if ( strDesignations.IsEmpty() ) // just disable all designation on GUI to mean unchanged actually
	{
		strDesignations = "N";
		bRepeat = true;
	}	
	///---END LOAD_FILTER_DESIGN_TO_DLG
	/// Hong 09/18/07 QA80-10387 FIX_DESIGNATION_INCONSISTENCE_BETWEEN_PRIVIEW_AND_IMPORT
	//Worksheet wks(s_strWks);
	//Worksheet wks(m_pSheet->GetWksName());
	//wks.SetColDesignations(strDesignations, bRepeat);
	//
	//string str = wks.GetColDesignations();
	/// end FIX_DESIGNATION_INCONSISTENCE_BETWEEN_PRIVIEW_AND_IMPORT

	return true;
}

BOOL ImpWizDataColumnsPage::OnClickFixedWidthPreview_AscColumns(Control ctrl)	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	AscColumns_EnableDelimiterCtrls();
	Button chkFixedWidthPreview(ctrl);
	if( !chkFixedWidthPreview.Check && IS_UPDATE_PREVIEW_NEEDED )
	{
		UpdatePreview(IDD_AIW_COLUMNS);
		DISABLE_UPDATE_PREVIEW_NEEDED;
	}
	/// JCG 06/12/03 QA50-4575 v7.0601 FIX_ITEM43_FIXWIDTH_BUG
	else
	if(chkFixedWidthPreview.Check)
		AscColumns_ReadFileIntoFixedWidthGrid();
	/// end FIX_ITEM43_FIXWIDTH_BUG
	return true;
}

BOOL ImpWizDataColumnsPage::OnClickAddCol_AscColumns(Control ctrl)	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	//Control ctrlGrid = ImportWizDlg.GetItem(IDC_COL_WIDTH_PREVIEW_GRID, IDD_AIW_COLUMNS);	///Jason 12/18/03 v7.5781 MOVE_TO_ON_INIT_DATA_COLUMNS
	//Object objGrid = m_ctrlGrid.GetActiveXControl();
	//if( objGrid )
	AscColumns_AddColToFixedWidthGrid();
	ENABLE_UPDATE_PREVIEW_NEEDED;
	return TRUE;
}

BOOL ImpWizDataColumnsPage::OnClickDelCol_AscColumns(Control ctrl)	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	//Control ctrlGrid = ImportWizDlg.GetItem(IDC_COL_WIDTH_PREVIEW_GRID, IDD_AIW_COLUMNS);	///Jason 12/18/03 v7.5781 MOVE_TO_ON_INIT_DATA_COLUMNS
	///Danice CHANGE_GRID_TO_CLASS
	//Object objGrid = m_ctrlGrid.GetActiveXControl();
	//if( objGrid )
	AscColumns_DeleteColFromFixedWidthGrid();
	///END CHANGE_GRID_TO_CLASS
	ENABLE_UPDATE_PREVIEW_NEEDED;
	return TRUE;
}

BOOL ImpWizDataColumnsPage::OnAfterResizeGridCol_AscColumns(Control ctrl, int nRow, int nCol)	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	m_vColWidths[nCol] = AscColumns_GetGridColWidthInChars(nCol);
	AscColumns_UpdateGridColTitle(nCol);
	AscColumns_UpdateFixedWidthColStr();
	ENABLE_UPDATE_PREVIEW_NEEDED;
	return TRUE;
}

void ImpWizDataColumnsPage::OnDrawCell_AscColumns(Control ctrl, UINT dwDC, int nRow, int nCol, int nLeft, int nTop, int nRight, int nBottom, BOOL* pDone)	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	HDC hDC = (HDC)dwDC;
	DeviceContext	dc;
	dc.Attach(hDC);
	SIZE sz;
	sz = dc.GetTextExtent("A", 1);
	dc.Detach();
	//s_iFixedWidthGridFontWidth = sz.cx;
	m_pSheet->SetFixedWidthGridFontWidth(sz.cx);
	
	*pDone = FALSE; // let VSFlex grid to finish drawing cell
	
	///Danice CHANGE_GRID_TO_CLASS
	/*
	Object objGrid = ctrl.GetActiveXControl();
	objGrid.OwnerDraw = flexODNone;
	*/
	m_ctrlPreviewList.SetOwnerDraw(flexODNone);
	///END CHANGE_GRID_TO_CLASS
	
	// First time showing the grid, let update the column widths.
	AscColumns_SetGridColWidthInChars(m_vColWidths);	
	AscColumns_ReadFileIntoFixedWidthGrid();
}

int ImpWizDataColumnsPage::AscColumns_GetGridColWidthInChars(int nCol)
{
	//Object objGrid = ctrlGrid.GetActiveXControl();
	//int iPixels = TwipsToPixels(ctrlGrid, objGrid.ColWidth(nCol));
	int iPixels = m_ctrlPreviewList.TwipsToPixels(m_ctrlPreviewList.GetColWidth(nCol));
	//return (iPixels / s_iFixedWidthGridFontWidth);//sizeChar.cx);
	return (iPixels / m_pSheet->GetFixedWidthGridFontWidth());
}

void ImpWizDataColumnsPage::AscColumns_UpdateGridColTitle(int nCol)
{
	string str;
	str.Format("%d\naaa", m_vColWidths[nCol]);

	///Danice CHANGE_GRID_TO_CLASS
	/*
	Object objGrid = ctrlGrid.GetActiveXControl();
	objGrid.Row = 0;
	objGrid.Col = nCol;
	objGrid.Text = str;
	*/
	m_ctrlPreviewList.SetColHeading(nCol, str);
	///END CHANGE_GRID_TO_CLASS
}

void ImpWizDataColumnsPage::AscColumns_SetGridColWidthInChars(int nCol, int nChars)
{
	///Danice CHANGE_GRID_TO_CLASS
	/*
	Object objGrid = ctrlGrid.GetActiveXControl();
	if( nCol >= objGrid.Cols )
		return;
	//int iTwips = PixelsToTwips(ctrlGrid, s_iFixedWidthGridFontWidth * nChars);
	int iTwips = PixelsToTwips(ctrlGrid, m_pSheet->GetFixedWidthGridFontWidth() * nChars);
	objGrid.ColWidth(nCol) = iTwips;
	*/
	m_ctrlPreviewList.SetGridColWidthInChars(nCol, nChars, m_pSheet->GetFixedWidthGridFontWidth());
	///END CHANGE_GRID_TO_CLASS
}

void ImpWizDataColumnsPage::AscColumns_SetGridColWidthInChars(vector<short> vColWidths)
{
	///Danice CHANGE_GRID_TO_CLASS
	//Object objGrid = ctrlGrid.GetActiveXControl();
	//objGrid.Cols = vColWidths.GetSize();
	//if( objGrid.Cols == 0 )
	m_ctrlPreviewList.SetCols(vColWidths.GetSize());
	if(m_ctrlPreviewList.GetCols() == 0)
	{
		AscColumns_AddColToFixedWidthGrid();
		AscColumns_ReadFileIntoFixedWidthGrid();
	}
	else
	{
		for( int iCol = 0; iCol < vColWidths.GetSize(); iCol++ )
		{
			AscColumns_SetGridColWidthInChars(iCol, vColWidths[iCol]);
			AscColumns_UpdateGridColTitle(iCol);
		}
	}
	///END CHANGE_GRID_TO_CLASS
}

void ImpWizDataColumnsPage::AscColumns_ReadFileIntoFixedWidthGrid()
{
	///Danice CHANGE_GRID_TO_CLASS
	
	//Control ctrlGrid = ImportWizDlg.GetItem(IDC_COL_WIDTH_PREVIEW_GRID, IDD_AIW_COLUMNS);	///Jason 12/18/03 v7.5781 MOVE_TO_ON_INIT_DATA_COLUMNS
	//Object objGrid = m_ctrlGrid.GetActiveXControl();
	
	//if( objGrid.Cols == 0 )
	if(m_ctrlPreviewList.GetCols() == 0)
		AscColumns_AddColToFixedWidthGrid();
	/*
	objGrid.Col = 0; // read into first column

	StringArray saLines;

	int nFixedRows = objGrid.FixedRows;
	if( nFixedRows > 1 ) // if show column names
	{
		///ReadFileLines(saLines, s_strDataFile, 1, s_ascimp.iHeaderLines - s_ascimp.iRenameCols);
		ReadFileLines(saLines, s_strDataFile, 1, ASCIMP_TOTAL_HEADER_LINES(m_pAscimp) - m_pAscimp->iRenameCols);
		objGrid.Row = 1;
		objGrid.Text = saLines[0];
		saLines.SetSize(0);
	}

	ReadFileLines(saLines, s_strDataFile, 50, ASCIMP_TOTAL_HEADER_LINES(m_pAscimp));
	objGrid.Rows = nFixedRows + saLines.GetSize();

	for( int n = 0; n < saLines.GetSize(); n++ )
	{
		objGrid.Row = nFixedRows + n;
		objGrid.Text = saLines[n];
	}
	*/
	m_ctrlPreviewList.ReadFileIntoFixedWidthGrid(s_strDataFile, ASCIMP_TOTAL_HEADER_LINES(m_pAscimp), m_pAscimp->iRenameCols);
	///END CHANGE_GRID_TO_CLASS
}

void ImpWizDataColumnsPage::AscColumns_AddColToFixedWidthGrid()
{
	///Danice 2/12/04 v8.0819 CHANGE_GRID_TO_CLASS
	/*
	Object objGrid = ctrlGrid.GetActiveXControl();
	int iCol = objGrid.Cols;
	objGrid.Cols = objGrid.Cols + 1;
	m_vColWidths.Add(AscColumns_GetGridColWidthInChars(ctrlGrid, iCol));
	AscColumns_UpdateGridColTitle(ctrlGrid, iCol);
	*/
	int iCol = m_ctrlPreviewList.GetCols();
	m_ctrlPreviewList.AddCol();
	///---Sim 03-12-2007 QA80-8584-S14 DEFAULT_WIDTH_OF_ADD_COLUMN_IS_SAME_WITH_THE_LAST_COLUMN
	int nChar = 9;
	if ( iCol > 0 )
		nChar = AscColumns_GetGridColWidthInChars(iCol-1);
	AscColumns_SetGridColWidthInChars(iCol, nChar);
	///---END QA80-8584-S14 DEFAULT_WIDTH_OF_ADD_COLUMN_IS_SAME_WITH_THE_LAST_COLUMN
	m_vColWidths.Add(AscColumns_GetGridColWidthInChars(iCol));
	AscColumns_UpdateGridColTitle(iCol);
	///END CHANGE_GRID_TO_CLASS
	AscColumns_UpdateFixedWidthColStr();
}

void ImpWizDataColumnsPage::AscColumns_DeleteColFromFixedWidthGrid()
{
	///Danice CHANGE_GRID_TO_CLASS
	/*
	Object objGrid = ctrlGrid.GetActiveXControl();
	int nCol = objGrid.Cols - 1;
	*/
	int nCol = m_ctrlPreviewList.GetCols() - 1;
	if( nCol )
	{
		//objGrid.Cols = nCol;
		m_ctrlPreviewList.SetCols(nCol);
		m_vColWidths.RemoveAt(nCol);
		AscColumns_UpdateFixedWidthColStr();
	}
	///END CHANGE_GRID_TO_CLASS
}

/// EJP 2005-03-04 v8.0200 QA70-7433 IMPORT_CSV_FILES
BOOL ImpWizDataColumnsPage::OnClickRemoveQuotes(Control ctrl)
{
	/// Hong 02/02/07 USE_STRUCTURE_NOT_FILTER
	/*
	///---Sim 08-31-2006 GET_FILTER_BY_ID
	if( m_btnRemoveQuotes.Check )
		//IW_FILTER.Common.Flags.nVal |= AI_FLAG_REMOVE_QUOTES;
		fuSetFlag(IW_FILTER, AI_FLAG_REMOVE_QUOTES, TRUE);
	else
		//IW_FILTER.Common.Flags.nVal &= ~AI_FLAG_REMOVE_QUOTES;
		fuSetFlag(IW_FILTER, AI_FLAG_REMOVE_QUOTES, FALSE);

	///---END GET_FILTER_BY_ID
	*/
	if( m_btnRemoveQuotes.Check )
		m_pAscimp->flags |= AI_FLAG_REMOVE_QUOTES;
	else
		m_pAscimp->flags &= ~AI_FLAG_REMOVE_QUOTES;
	/// end USE_STRUCTURE_NOT_FILTER
	UpdatePreview(IDD_AIW_COLUMNS);
	return TRUE;
}
/// end IMPORT_CSV_FILES

void ImpWizDataColumnsPage::AscColumns_UpdateData(BOOL bFromDialogToASCIMP) //=TRUE)
{
	///Jason 12/18/03 v7.5781 MOVE_TO_ON_INIT_DATA_COLUMNS
	//Control wizpage = ImportWizDlg.GetItem(IDD_AIW_COLUMNS);
	//ComboBox cmbDelimiter = ImportWizDlg.GetItem(IDC_COLS_DELIMITER, IDD_AIW_COLUMNS);
	//Edit ebDelimiter = ImportWizDlg.GetItem(IDC_COLS_CHAR, IDD_AIW_COLUMNS);
	//Edit ebFixedWidths = ImportWizDlg.GetItem(IDC_COLS_WIDTHS, IDD_AIW_COLUMNS);
	//ComboBox cmbDesig = ImportWizDlg.GetItem(IDC_IW_COL_PLOT_DESIG, IDD_AIW_COLUMNS);
	//Button btnLeadingZeroes = ImportWizDlg.GetItem(IDC_IW_LEADING_ZERO, IDD_AIW_COLUMNS);
	//Edit ebNumCols = ImportWizDlg.GetItem(IDC_NUMBER_OF_COLS, IDD_AIW_COLUMNS);
	//ComboBox cbDateFormat = ImportWizDlg.GetItem(IDC_CUSTOM_DATE_FORMAT, IDD_AIW_COLUMNS); /// EJP 10-13-2003 v7.5717 QA70-5318 CUSTOM_DATE_FORMAT
	///End MOVE_TO_ON_INIT_DATA_COLUMNS

	string str;
	int i; /// EJP 2005-06-23 v8.0256 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS
	
	if( bFromDialogToASCIMP )
	{
		m_pAscimp->iDelimited = (GetCheckedRadioButton(IDC_COLS_DELIMITED, IDC_COLS_FIXED) == IDC_COLS_DELIMITED);
		
		/// EJP 2005-09-23 v8.0309 QA70-7473 ASC_IMP_MULT_DELIM
		///m_pAscimp->iDelimiter = m_cmbDelimiter.GetCurSel();
		UpdateASCIMPDelimitersFromDialog();
		/// end ASC_IMP_MULT_DELIM
		
		m_pAscimp->cChar = m_ebDelimiter.Text[0];
		
		lstrcpyn(m_pAscimp->szFixedWidth, m_editFixedWidths.Text, MAX_FIXED_COL_WIDTH);

		m_pAscimp->iLeadingZeroes = m_btnLeadingZeroes.Check;

		/// EJP 2005-06-23 v8.0256 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS
		i = m_cbNumSeparator.GetCurSel();
		m_pAscimp->nNumSep = m_cbNumSeparator.GetItemData(i);
		/// end ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS
		///---Sim 08-06-2007 SUPPORT_SMART_SPARKLINE
		//fuSetSparkLine(IW_FILTER,m_chkAddSparklines.Check);// Hong 01/17/07 ADD_SPARKLINE_TO_IMPORT_WIZARD
		int nSparklines = m_cbSparklines.GetCurSel();
		fuSetSparkLine(IW_FILTER, nSparklines);
		///---END SUPPORT_SMART_SPARKLINE
		
		if( m_chkForceSameSize.Check )
			m_pAscimp->flags |= AI_FLAG_ADD_NANUM_MAKE_SAME_LENGTH;
		else
			m_pAscimp->flags &= ~AI_FLAG_ADD_NANUM_MAKE_SAME_LENGTH;// Hong 03/26/07 v8.0589b ADD_FORCE_ROW_SAME_SIZE
		/// Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT
		if( m_chkKeepColFormat.Check )
			m_pAscimp->flags |= AI_FLAG_KEEP_TARGET_SHEET_COL_FORMAT;
		else
			m_pAscimp->flags &= ~AI_FLAG_KEEP_TARGET_SHEET_COL_FORMAT;
		/// end MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT
	}
	else // from ASCIMP to dialog
	{
		if( m_pAscimp->iDelimited )
			CheckRadioButton(IDC_COLS_DELIMITED, IDC_COLS_FIXED, IDC_COLS_DELIMITED);
		else
			CheckRadioButton(IDC_COLS_DELIMITED, IDC_COLS_FIXED, IDC_COLS_FIXED);

		/// EJP 2005-09-23 v8.0309 QA70-7473 ASC_IMP_MULT_DELIM
		///m_cmbDelimiter.SetCurSel(m_pAscimp->iDelimiter);
		UpdateDialogFromASCIMPDelimiters();
		/// end ASC_IMP_MULT_DELIM

		str.Format("%s", m_pAscimp->szFixedWidth);
		m_editFixedWidths.Text = str;

		///---Sim 06-05-2007 LOAD_FILTER_DESIGN_TO_DLG
		/*
		//m_cmbDesig.SetCurSel(0);
		m_cmbDesig.SetCurSel(1); // Hong 01/03/06 DEFAULT_USE_XYY
		*/
		/// Hong 09/21/07 QA80-10397 COL_DESIGN_BE_EDITABLE_NO_NEED_INITIAL_BY_FILTER
		//LoadDesignation(s_trFilter);
		/// Hong 10/10/09 QA80-14079-P2 COL_DESIG_SETTING_LOST_UNFRIENDLY_AFTER_FORWARD_BACK
		//m_cmbDesig.SetCurSel(0);
		string			strDesignations;
		if ( GetGUIColDesig(s_trFilter, strDesignations) )
			m_cmbDesig.Text = strDesignations;
		else
			m_cmbDesig.SetCurSel(0);
		/// end COL_DESIG_SETTING_LOST_UNFRIENDLY_AFTER_FORWARD_BACK
		/// end COL_DESIGN_BE_EDITABLE_NO_NEED_INITIAL_BY_FILTER
		///---END LOAD_FILTER_DESIGN_TO_DLG
		

		m_btnLeadingZeroes.Check = m_pAscimp->iLeadingZeroes;
		
		m_ebNumCols.Text.Format("%d", m_pAscimp->iNumColumns);

		/// EJP 10-13-2003 v7.5717 QA70-5318 CUSTOM_DATE_FORMAT
		if( m_pAscimp->szDateFormat[0] )
			m_cbDateFormat.Text = m_pAscimp->szDateFormat;
		else
			m_cbDateFormat.SetCurSel(0); // select <None> text
		/// end CUSTOM_DATE_FORMAT
		
		/// Hong 02/02/07 USE_STRUCTURE_NOT_FILTER
		/*
		///---Sim 08-31-2006 GET_FILTER_BY_ID
		/// EJP 2005-03-04 v8.0200 QA70-7433 IMPORT_CSV_FILES
		//DWORD dwFlags = tree_node_get_int(IW_FILTER.Common.Flags, 0);
		//m_btnRemoveQuotes.Check = (dwFlags & AI_FLAG_REMOVE_QUOTES);
		m_btnRemoveQuotes.Check = fuGetFlag(IW_FILTER, AI_FLAG_REMOVE_QUOTES, 0);
		/// end IMPORT_CSV_FILES
		///---END GET_FILTER_BY_ID
		*/
		m_btnRemoveQuotes.Check = m_pAscimp->flags & AI_FLAG_REMOVE_QUOTES;
		/// end USE_STRUCTURE_NOT_FILTER
		
		/// EJP 2005-06-23 v8.0256 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS
		i = m_pAscimp->nNumSep;
		/// Hong QA80-9972 REMOVE_ORIGIN_SETTING_FOR_NUMERIC_SEPARATOR
		//if( i < NF_IS_ORIGIN || NF_IS_UNKNOWN <= i || i == NF_IS_WINDOWS )			
		//	i = NF_IS_ORIGIN;
		if ( NF_IS_AMERICAN > i || NF_IS_UNKNOWN <= i )
		{
			i = NF_IS_AMERICAN;
			/// Hong 11/20/07 QA80-10723 FIX_GUI_VALUES_NOT_SAVE_INTO_FILTERS
			m_pAscimp->nNumSep = i;
			/// end FIX_GUI_VALUES_NOT_SAVE_INTO_FILTERS
		}
			/// end REMOVE_ORIGIN_SETTING_FOR_NUMERIC_SEPARATOR		
		m_pSheet->SetComboBoxCurSelByData(m_cbNumSeparator, i);
		/// end ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS
		///---Sim 08-06-2007 SUPPORT_SMART_SPARKLINE
		//m_chkAddSparklines.Check = fuGetSparkLine(IW_FILTER); // Hong 01/17/07 ADD_SPARKLINE_TO_IMPORT_WIZARD
		int nSparklines = fuGetSparkLine(IW_FILTER);
		m_cbSparklines.SetCurSel(nSparklines);
		///---END SUPPORT_SMART_SPARKLINE
		
		m_chkForceSameSize.Check = m_pAscimp->flags & AI_FLAG_ADD_NANUM_MAKE_SAME_LENGTH; // Hong 03/26/07 v8.0589b ADD_FORCE_ROW_SAME_SIZE	 
		
		m_chkKeepColFormat.Check = m_pAscimp->flags & AI_FLAG_KEEP_TARGET_SHEET_COL_FORMAT; // Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT 
		
		// this will OnEditChangeCharacter_AscColumns event which will do UpdatePreview, so better to put after all finish initial
		str.Format("%c", m_pAscimp->cChar);
		m_ebDelimiter.Text = str;
	}
	
	UpdateTextQualifier(bFromDialogToASCIMP);
}
void ImpWizDataColumnsPage::UpdatePreview(int iWizPageID)
{
	_MSG_INT(UpdatePreview, m_pAscimp->iDelimited)
	/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	if ( m_bDisableUpdatePreview )
		return ;
	/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	///Danice 12/25/03 v7.5788 SAVE_BEFORE_CHANGE		///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	//m_pSheet->SetASCIMP(m_pAscimp);
	//m_pSheet->UpdateImpStructCommonFromTree(); ///---Sim 08-31-2006 NO_NEED_GET_FROM_COMMON_NODE
	m_pSheet->ImportToWks();
	//m_pSheet->GetASCIMP(m_pAscimp);
	///END SAVE_BEFORE_CHANGE
	
	UpdateWksCtrl(iWizPageID);
}


/// EJP 07-14-2003 v7.0624 SCAN_FOR_NUM_COLS_ON_CHANGE_HEADER_LINES
int ImpWizDataColumnsPage::iwScanForNumColumns(LPCSTR lpcszFile, ASCIMP& ascimp)
{
	ASCIMP aiTemp;
	aiTemp = ascimp;
	AscImpReadFileStruct(lpcszFile, &aiTemp, AIRF_USE_ASCIMP);
	ascimp.iPartialC2 = -1;// Hong 9/21/06 PARTIAL_DEFAULT_SELECT_ALL
	return aiTemp.iNumColumns;
}
/// end SCAN_FOR_NUM_COLS_ON_CHANGE_HEADER_LINES

void ImpWizDataColumnsPage::UpdateWksCtrl(int iWizPageID)
{
	///Danice 12/26/03 v7.5789 UPDATE_DIRECTLY
/*		int iCtrlID;
	switch( iWizPageID )
	{
	case IDD_AIW_COLUMNS:
		iCtrlID = IDC_COL_WKS_PREVIEW;
		break;
	case IDD_IW_RANGE:
		iCtrlID = IDC_RANGE_PREVIEW;
		break;
	case IDD_BIW_DATAPATERN:
		iCtrlID = IDC_BIW_DATAPATERN_PREVIEW_LC;
		break;
	default:
		return;
	}*/
	///END UPDATE_DIRECTLY

	//WorksheetControl wc = ImportWizDlg.GetItem(iCtrlID, iWizPageID);
	//WorksheetControl wc = GetItem(IDC_COL_WKS_PREVIEW);		///Jason 12/18/03 v7.5781 NO_NEED_DIALOG_CALL	
	////wc.Attach(s_strWks);
	///wc.Attach(m_pSheet->GetWksName());
	//wc.Update();
	//WorksheetControl wc = GetItem(IDC_COL_WKS_PREVIEW);		///Jason 12/18/03 v7.5781 NO_NEED_DIALOG_CALL	
	////wc.Attach(s_strWks);
	m_wc.Attach(m_pSheet->GetWksName());
	m_wc.Update();
}

/// EJP 2005-09-23 v8.0309 QA70-7473 ASC_IMP_MULT_DELIM
BOOL ImpWizDataColumnsPage::OnClickDelimiter(Control ctrl)
{
	AscColumns_EnableDelimiterCtrls();
	UpdateASCIMPDelimitersFromDialog();
	UpdatePreview(IDD_AIW_COLUMNS);
	return TRUE;
}
///---Sim 08-06-2007 SUPPORT_SMART_SPARKLINE
/*
/// Hong 01/17/07 ADD_SPARKLINE_TO_IMPORT_WIZARD	
BOOL ImpWizDataColumnsPage::OnClickAddSparklines(Control ctrl)
{
	Button chk = ctrl;
	fuSetSparkLine(IW_FILTER,chk.Check);
	return TRUE;
}
/// end ADD_SPARKLINE_TO_IMPORT_WIZARD
*/
BOOL ImpWizDataColumnsPage::OnSelChangeSparklines(Control ctrl)
{
	ComboBox cbSparklines = ctrl;
	int nSparklines = cbSparklines.GetCurSel();
	fuSetSparkLine(IW_FILTER, nSparklines);
	return TRUE;
}
///---END SUPPORT_SMART_SPARKLINE

/// Hong 03/27/09 QA80-13360 ADD_HINT_ITEM_FOR_DATA_FMT_COMBO
BOOL ImpWizDataColumnsPage::OnSelChangeDataFormat(Control ctrl)
{
	string		strText;
	m_cbDateFormat.GetLBText(m_cbDateFormat.GetCurSel(), strText);
	if ( 0 == strText.CompareNoCase(STR_HINT_ITEM) )
	{
		string	strOldText = m_cbDateFormat.Text;
		MessageBox(GetSafeHwnd(), _L("You can type directly to customize your desirable format."), _L("Hint for Custom Date Format"), MB_OK | MB_ICONINFORMATION);
		m_cbDateFormat.SelectString(0, strOldText);
	}
	/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	Control		ctrlApply = GetItem(IDC_APPLY_DATE_FORMAT);
	if ( ctrlApply )
		ctrlApply.Enable = TRUE;
	/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	return TRUE;
}
/// end ADD_HINT_ITEM_FOR_DATA_FMT_COMBO

/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
BOOL ImpWizDataColumnsPage::OnChangeNumCols(Control ctrl)
{
	Control		ctrlApply = GetItem(IDC_APPLY_NUM_COLS);
	if ( ctrlApply )
		ctrlApply.Enable = TRUE;
	return TRUE;
}

BOOL ImpWizDataColumnsPage::OnChangeDateFormat(Control ctrl)
{
	Control		ctrlApply = GetItem(IDC_APPLY_DATE_FORMAT);
	if ( ctrlApply )
		ctrlApply.Enable = TRUE;
	return TRUE;
}

BOOL ImpWizDataColumnsPage::OnChangePlotDisg(Control ctrl)
{
	Control		ctrlApply = GetItem(IDC_IW_COL_SET_PLOT_DESIG);
	if ( ctrlApply )
		ctrlApply.Enable = TRUE;
	return TRUE;
}

BOOL ImpWizDataColumnsPage::OnSelChangePlotDisg(Control ctrl)
{
	Control		ctrlApply = GetItem(IDC_IW_COL_SET_PLOT_DESIG);
	if ( ctrlApply )
		ctrlApply.Enable = TRUE;
	return TRUE;
}
/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT

/// Hong 03/26/07 v8.0589b ADD_FORCE_ROW_SAME_SIZE
BOOL ImpWizDataColumnsPage::OnClickForceSameSize(Control ctrl)
{
	Button chk = ctrl;
	
	if( chk.Check )
		m_pAscimp->flags |= AI_FLAG_ADD_NANUM_MAKE_SAME_LENGTH;
	else
		m_pAscimp->flags &= ~AI_FLAG_ADD_NANUM_MAKE_SAME_LENGTH;
	
	return TRUE;
}
/// end ADD_FORCE_ROW_SAME_SIZE

/// Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT
BOOL ImpWizDataColumnsPage::OnClickKeepColFormat(Control ctrl)
{
	Button chk = ctrl;
	
	if( chk.Check )
		m_pAscimp->flags |= AI_FLAG_KEEP_TARGET_SHEET_COL_FORMAT;
	else
		m_pAscimp->flags &= ~AI_FLAG_KEEP_TARGET_SHEET_COL_FORMAT;
	
	return TRUE;
}
/// end MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT

BOOL ImpWizDataColumnsPage::OnClickCombineConsecDelim(Control ctrl)
{
	Button chk = ctrl;
	/// Hong 02/02/07 USE_STRUCTURE_NOT_FILTER
	/*
	///---Sim 08-31-2006 GET_FILTER_BY_ID
	if( chk.Check )
		//IW_FILTER.Common.Flags.nVal |= AI_FLAG_COMBINE_CONSEC_DELIMS;
		fuSetFlag(IW_FILTER, AI_FLAG_COMBINE_CONSEC_DELIMS, TRUE);
	else
		//IW_FILTER.Common.Flags.nVal &= ~AI_FLAG_COMBINE_CONSEC_DELIMS;
		fuSetFlag(IW_FILTER, AI_FLAG_COMBINE_CONSEC_DELIMS, FALSE);
	///---END GET_FILTER_BY_ID
	*/
	if( chk.Check )
		m_pAscimp->flags |= AI_FLAG_COMBINE_CONSEC_DELIMS;
	else
		m_pAscimp->flags &= ~AI_FLAG_COMBINE_CONSEC_DELIMS;
	/// end USE_STRUCTURE_NOT_FILTER
	UpdatePreview(IDD_AIW_COLUMNS);
	return TRUE;
}

BOOL ImpWizDataColumnsPage::OnSelChangeTextQualifier(Control ctrl)
{
	int nCurSel = m_cbTextQualifier.GetCurSel();
	string str;
	if( nCurSel >= 0 )
		m_cbTextQualifier.GetLBText(nCurSel, str);
	m_cbTextQualifier.Text = str;
	UpdateTextQualifier(TRUE);
	UpdatePreview(IDD_AIW_COLUMNS);
	return TRUE;
}

BOOL ImpWizDataColumnsPage::OnEditChangeTextQualifier(Control ctrl)
{
	UpdateTextQualifier(TRUE);
	UpdatePreview(IDD_AIW_COLUMNS);
	return TRUE;
}

int ImpWizDataColumnsPage::UpdateASCIMPDelimitersFromDialog()
{
	memset(m_pAscimp->cDelimiters, 0, ASCIMP_MAX_DELIMITERS);
	int nDelimCount = 0;
	if( m_chkColDelimTab.Check )
	{
		m_pAscimp->iDelimiter = ASCIMP_DELIM_TAB;
		m_pAscimp->cDelimiters[nDelimCount++] = '\t';
	}
	if( m_chkColDelimComma.Check )
	{
		m_pAscimp->iDelimiter = ASCIMP_DELIM_COMMA;
		m_pAscimp->cDelimiters[nDelimCount++] = ',';
	}
	if( m_chkColDelimSpace.Check )
	{
		m_pAscimp->iDelimiter = ASCIMP_DELIM_SPACE;
		m_pAscimp->cDelimiters[nDelimCount++] = ' ';
	}
	if( m_chkColDelimSemiColon.Check )
	{
		/// Hong 11/30/07 QA80-10541 FIX_SEMICOLON_SEPARATOR_FAIL_WORK_AS_MIXED_UP_USER_SEPARATOR
		//m_pAscimp->iDelimiter = ASCIMP_DELIM_OTHER;
		m_pAscimp->iDelimiter = ASCIMP_DELIM_DEMICOLON;
		/// end FIX_SEMICOLON_SEPARATOR_FAIL_WORK_AS_MIXED_UP_USER_SEPARATOR
		/// Hong 09/04/07 QA80-9910 v8.0695 FIX_DELIMITER_OTHER_FAIL_INITIAL_BY_FILTER
		//m_pAscimp->cChar = ';';
		//m_pAscimp->cDelimiters[nDelimCount++] = m_pAscimp->cChar;
		m_pAscimp->cDelimiters[nDelimCount++] = ';';
		/// end FIX_DELIMITER_OTHER_FAIL_INITIAL_BY_FILTER
	}
	if( m_chkColDelimOther.Check )
	{		
		m_pAscimp->iDelimiter = ASCIMP_DELIM_OTHER;		
		string str = m_ebDelimiter.Text;
		///Hong 8/15/06 FIX_EMPTY_INPUT
		//m_pAscimp->cChar = str[0];
		//m_pAscimp->cDelimiters[nDelimCount++] = m_pAscimp->cChar;
		if(!str.IsEmpty())
		{
			m_pAscimp->cChar = str[0];
			m_pAscimp->cDelimiters[nDelimCount++] = m_pAscimp->cChar;
		}
		///end FIX_EMPTY_INPUT
	}
	else
	{
		m_pAscimp->cChar = 0; /// Hong 09/04/07 QA80-9910 v8.0695 FIX_DELIMITER_OTHER_FAIL_INITIAL_BY_FILTER
	}
	if( 1 != nDelimCount )
	{
		m_pAscimp->iDelimiter = ASCIMP_DELIM_UNKNOWN;
		//m_pAscimp->cChar = 0; /// Hong 09/04/07 QA80-9910 v8.0695 FIX_DELIMITER_OTHER_FAIL_INITIAL_BY_FILTER
	}
	return 0;
}

void ImpWizDataColumnsPage::CheckDelimiter(char c)
{
	switch( c )
	{
	case '\t':
		m_chkColDelimTab.Check = 1;
		break;
	case ',':
		m_chkColDelimComma.Check = 1;
		break;
	case ' ':
		m_chkColDelimSpace.Check = 1;
		break;
	case ';':
		m_chkColDelimSemiColon.Check = 1;
		break;
	default:
		if( '!' <= c && c <= '~' )
		{
			m_chkColDelimOther.Check = 1;
			m_ebDelimiter.Text.Format("%c", c);
		}
		break;
	}
}

int ImpWizDataColumnsPage::UpdateDialogFromASCIMPDelimiters()
{
	m_chkColDelimTab.Check = 0;
	m_chkColDelimComma.Check = 0;
	m_chkColDelimSpace.Check = 0;
	m_chkColDelimSemiColon.Check = 0;
	m_chkColDelimOther.Check = 0;

	switch( m_pAscimp->iDelimiter )
	{
	case ASCIMP_DELIM_TAB:
		CheckDelimiter('\t');
		break;
	case ASCIMP_DELIM_COMMA:
		CheckDelimiter(',');
		break;
	case ASCIMP_DELIM_SPACE:
		CheckDelimiter(' ');
		break;
	case ASCIMP_DELIM_OTHER:
		CheckDelimiter(m_pAscimp->cChar);
		break;
	}

	int nDelim = 0;
	while( nDelim < ASCIMP_MAX_DELIMITERS && m_pAscimp->cDelimiters[nDelim] )
		CheckDelimiter(m_pAscimp->cDelimiters[nDelim++]);
	
	return 0;
}

void ImpWizDataColumnsPage::UpdateTextQualifier(BOOL bFromDialogToASCIMP)
{
	if( bFromDialogToASCIMP )
	{
		string str = m_cbTextQualifier.Text;
		if( 0 == str.CompareNoCase(SZ_IW_NONE) )
			m_pAscimp->cQuote = 0;
		else
			m_pAscimp->cQuote = str[0];
	}
	else // from ASCIMP to dialog
	{
		if( m_pAscimp->cQuote )
			m_cbTextQualifier.Text.Format("%c", m_pAscimp->cQuote);
		else
			m_cbTextQualifier.SetCurSel(0);
	}
	m_btnRemoveQuotes.Enable = m_pAscimp->cQuote;
}
/// end ASC_IMP_MULT_DELIM

///---Sim 06-05-2007 LOAD_FILTER_DESIGN_TO_DLG
void ImpWizDataColumnsPage::LoadDesignation(const TreeNode& trFilter)
{
	vector<string> vs;
	for ( int ii = 0; ii < m_cmbDesig.GetCount(); ii++ )
	{
		string str;
		m_cmbDesig.GetLBText(ii, str);
		vs.Add(str);
	}
	
	/// Hong 10/10/09 QA80-14079-P2 COL_DESIG_SETTING_LOST_UNFRIENDLY_AFTER_FORWARD_BACK
	/*
	string strDesignations = fuGetDesignations(trFilter);
	bool bRepeat = fuGetRepetitive(trFilter);
	
	int nSel = -1;
	if ( strDesignations.IsEmpty() )
	{ // unchange designation
		//------ Folger 11/08/07 CLEAN_CODE_TO_LOCALIZE
		//nSel = vs.Find(STR_DESIGN_UNCHANGED);
		for (int ii=0; ii<vs.GetSize(); ++ii)
		{
			if (compare_string_localization(vs[ii], STR_DESIGN_UNCHANGED))
			{
				nSel = ii;
				break;
			}
		}
		//------ End CLEAN_CODE_TO_LOCALIZE
	}
	else
	{
		strDesignations.Replace("E", "YErr");
		
		if ( bRepeat )
			strDesignations += " " + strDesignations;
		nSel = vs.Find(strDesignations);
	}
	*/
	int 		nSel = -1;
	string 		strDesignations;
	if ( GetGUIColDesig(trFilter, strDesignations) )
	{
		nSel = vs.Find(strDesignations);
	}
	else
	{
		//------ Folger 11/08/07 CLEAN_CODE_TO_LOCALIZE
		//nSel = vs.Find(STR_DESIGN_UNCHANGED);
		for (int ii=0; ii<vs.GetSize(); ++ii)
		{
			if (compare_string_localization(vs[ii], STR_DESIGN_UNCHANGED))
			{
				nSel = ii;
				break;
			}
		}
		//------ End CLEAN_CODE_TO_LOCALIZE
	}
	/// end COL_DESIG_SETTING_LOST_UNFRIENDLY_AFTER_FORWARD_BACK

	if ( nSel < 0 )
	{
		nSel = vs.Find(STR_DESIGN_DEFAULT);
		ASSERT( nSel >= 0 );
		
		//fuSetDesignations(trFilter, STR_DESIGN_DEFAULT);
		//fuSetRepetitive(trFilter, false);
	}
	
	m_cmbDesig.SetCurSel(nSel);
}

///---END LOAD_FILTER_DESIGN_TO_DLG

/// Hong 10/10/09 QA80-14079-P2 COL_DESIG_SETTING_LOST_UNFRIENDLY_AFTER_FORWARD_BACK
bool ImpWizDataColumnsPage::GetGUIColDesig(const TreeNode& trFilter, string& strDesignations)
{
	strDesignations = fuGetDesignations(trFilter);
	bool bRepeat = fuGetRepetitive(trFilter);
	
	if ( strDesignations.IsEmpty() )
		return false;

	strDesignations.Replace("E", "YErr");
	
	if ( bRepeat )
		strDesignations += " " + strDesignations;

	return true;
}
/// end COL_DESIG_SETTING_LOST_UNFRIENDLY_AFTER_FORWARD_BACK